﻿using System;
using VA.TMP.Integration.VIMT.Messages.Vista;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;
using VA.TMP.Integration.VIMT.Vista.Mappers;
using VA.TMP.Integration.VIMT.Shared;
using VA.TMP.Integration.VIMT.Vista.Links;
using VIMT.VIAEMRService.Messages;


namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.MakeAppointment
{
    public class CreateResponseStep : FilterBase<MakeAppointmentStateObject>
    {
        public override void Execute(MakeAppointmentStateObject state)
        {
            if (!string.IsNullOrEmpty(state.VistaFakeResponseType))
            {
                state.MakeAppointmentResponseMessage = new MakeAppointmentResponseMessage
                {
                    ExceptionMessage = "*****THIS IS FAKE DATA. DATA NOT SENT TO Vista*****",
                    ExceptionOccured = false,
                    SerializedInstance = state.SerializedAppointment,
                    PatVistaAppointment = VistaSchedulingUtilities.MapAppointmentEcToLob(Side.Patient, state, Logger.Instance),
                    ProVistaAppointment = VistaSchedulingUtilities.MapAppointmentEcToLob(Side.Provider, state, Logger.Instance)
                };
            }
            else
            {
                state.MakeAppointmentResponseMessage = state.ExceptionOccured
                  ? new MakeAppointmentResponseMessage
                  {
                      ExceptionOccured = true,
                      ExceptionMessage = state.ExceptionMessage,
                      SerializedInstance = state.SerializedAppointment,
                      EcProcessingMs = state.EcProcessingTimeMs
                  }
                  : new MakeAppointmentResponseMessage
                  {
                      ExceptionMessage = string.Empty,
                      ExceptionOccured = false,
                      SerializedInstance = state.SerializedAppointment,
                      PatVistaAppointment = VistaSchedulingUtilities.MapAppointmentEcToLob(Side.Patient, state, Logger.Instance),
                      ProVistaAppointment = VistaSchedulingUtilities.MapAppointmentEcToLob(Side.Provider, state, Logger.Instance),
                      EcProcessingMs = state.EcProcessingTimeMs
                  };
            }
        }
    }
}
